{*****************************************************************************
*
* Module:      DATACOMBOBOX.PAS
*
* Author:      Stefan Wloch
* Date:        19-08-1997
* Version:     1.0
*
* Environment: Delphi 1.0, 2.0 & 3.0
* Compiler:
* Target:      WINDOWS 95 & WINDOWS NT
*
*-----------------------------------------------------------------------------
* Description: TDataComboBox Component
*-----------------------------------------------------------------------------
* Modifications:
*
* Date      By       Description
* --------------------------------------------------------------------
*
*
******************************************************************************}
unit datacombobox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, StdCtrls;

type
  TDataComboBox = class(TComboBox)
  protected
    function GetDataItem(ndx: Integer): LongInt;
    procedure SetDataItem(ndx: Integer; val: LongInt);
  public
    property DataItem[ndx: Integer]: LongInt read GetDataItem write SetDataItem;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Standard', [TDataComboBox]);
end;

function TDataComboBox.GetDataItem(ndx: Integer): LongInt;
begin
     Result:=SendMessage(handle, CB_GETITEMDATA, ndx, 0);
end;

procedure TDataComboBox.SetDataItem(ndx: Integer; val: LongInt);
begin
     SendMessage(handle, CB_SETITEMDATA, ndx, val);
end;

end.

